// Function to send a message
function sendMessage() {
    // Get the message from the input field
    const message = document.getElementById('message').value;

    // Create a new forum block for the message
    const forumBlock = document.createElement('div');
    forumBlock.classList.add('forum-block');

    // Create the image element
    const img = document.createElement('img');
    img.src = 'Anna.jpg';
    img.alt = 'Anna Kowalska';

    // Create the paragraph element
    const p = document.createElement('p');
    p.innerText = message;

    // Append the image and paragraph to the forum block
    forumBlock.appendChild(img);
    forumBlock.appendChild(p);

    // Prepend the forum block to the posts section
    const postsSection = document.querySelector('.posts');
    postsSection.insertBefore(forumBlock, postsSection.firstChild);

    // Scroll to the new message
    forumBlock.scrollIntoView();

    // Clear the input field
    document.getElementById('message').value = '';
}

// Function to generate a random response
function generateRandomResponse() {
    // Array of predefined responses
    const responses = [
        'Tak, polecam kurs na Udemy!',
        'Nie, nie znam żadnego.',
        'Może spróbuj na Coursera?',
        'Sprawdź na edX.',
        'Polecam Codecademy.',
        'Udemy ma dobre kursy.',
        'Khan Academy jest świetna.',
        'Możesz spróbować na Pluralsight.',
        'Warto sprawdzić na LinkedIn Learning.'
    ];

    // Generate a random index
    const randomIndex = Math.floor(Math.random() * responses.length);

    // Get the random response
    const response = responses[randomIndex];

    // Create a new forum block for the response
    const forumBlock = document.createElement('div');
    forumBlock.classList.add('forum-block');

    // Create the image element
    const img = document.createElement('img');
    img.src = 'Jan.jpg';
    img.alt = 'Jan Nowak';

    // Create the paragraph element
    const p = document.createElement('p');
    p.innerText = response;

    // Append the image and paragraph to the forum block
    forumBlock.appendChild(img);
    forumBlock.appendChild(p);

    // Prepend the forum block to the posts section
    const postsSection = document.querySelector('.posts');
    postsSection.insertBefore(forumBlock, postsSection.firstChild);

    // Scroll to the new response
    forumBlock.scrollIntoView();
}
